#include "CGen2KillDialog.h"

#include <QMessageBox>

#include <tag/QrfeGen2Tag>


CGen2KillDialog::CGen2KillDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	setInfoEdit(ui.infoEdit);

	connect(ui.okButton, 			SIGNAL(clicked()), 					this, SLOT(tryAccept()));
	connect(ui.cancelButton, 		SIGNAL(clicked()), 					this, SLOT(reject()));

}

CGen2KillDialog::~CGen2KillDialog()
{

}


int CGen2KillDialog::exec(QrfeGen2Tag* tag)
{
	m_tag = tag;

	clearInfo();

	ui.tagIdEdit->setText(m_tag->tagId());
	ui.passwordLineEdit->setText("00-00-00-00");

	return QDialog::exec();
}


void CGen2KillDialog::tryAccept()
{
	clearInfo();

	if(!ui.passwordLineEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not a valid!");
		return;
	}

	bool ok = false;
	QByteArray passw = QrfeGlobal::stringToBytes(ui.passwordLineEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not a valid!");
		return;
	}

	QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

	res = m_tag->killTag(passw);

	if(res == QrfeGlobal::TMI_OK){
		infoSetOK("-- Kill tag " + ui.tagIdEdit->text() + " - OK -- ");
		QMessageBox::information(this, "Kill", "Killed tag " + ui.tagIdEdit->text());
		QDialog::accept();
	}
	else
		handleError(res, "Could not kill tag");
}

